<?php
// Sāk jaunu sesiju, lai piekļūtu sesijas mainīgajiem
session_start();

// Pieslēdzas datubāzei
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Izveido savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojuma statusu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Iegūst testa veidotāja lietotāja ID no sesijas
$creator_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;

// Iegūst testa datus no formas
$name = isset($_POST['name']) ? $_POST['name'] : '';
$description = isset($_POST['description']) ? $_POST['description'] : '';
$category = isset($_POST['category']) ? $_POST['category'] : ''; // Pievienota kategorija
$questions = isset($_POST['question']) ? $_POST['question'] : array();
$answers = isset($_POST['answers']) ? $_POST['answers'] : array();
$corrects = isset($_POST['corrects']) ? $_POST['corrects'] : array();

// Sagatavo un piesaista
$stmt = $conn->prepare("INSERT INTO tests (name, description, category, creator_id) VALUES (?, ?, ?, ?)");
$stmt->bind_param("sssi", $name, $description, $category, $creator_id);

// Izpilda vaicājumu
if ($stmt->execute()) {
    $test_id = $conn->insert_id;

    // Iterē caur jautājumiem un ievieto tos datu bāzē
    foreach ($questions as $index => $question) {
        // Sagatavo vaicājumu
        $stmt_questions = $conn->prepare("INSERT INTO questions (test_id, question) VALUES (?, ?)");

        // Pārbauda vai sagatavošana bija veiksmīga
        if ($stmt_questions) {
            $stmt_questions->bind_param("is", $test_id, $question);
            // Izpilda vaicājumu
            if ($stmt_questions->execute()) {
                $question_id = $conn->insert_id;

                // Ievieto atbildes šim jautājumam
                foreach ($answers[$index] as $answerIndex => $answer) {
                    // Pārbauda, vai atbilde nav tukša
                    if (!empty($answer)) {
                        $is_correct = ($corrects[$index] == $answerIndex) ? 1 : 0; // Pārbauda, vai šī atbilde ir atzīmēta kā pareiza
                        $stmt_answers = $conn->prepare("INSERT INTO answers (question_id, answer, is_correct) VALUES (?, ?, ?)");
                        if ($stmt_answers) {
                            $stmt_answers->bind_param("isi", $question_id, $answer, $is_correct);
                            // Izpilda vaicājumu
                            if (!$stmt_answers->execute()) {
                                echo "Kļūda izpildot atbilžu vaicājumu: " . $stmt_answers->error . "<br>";
                            }
                        } else {
                            echo "Kļūda sagatavojot atbilžu vaicājumu: " . $conn->error . "<br>";
                        }
                    }
                }
            } else {
                echo "Kļūda izpildot jautājumu vaicājumu: " . $stmt_questions->error . "<br>";
            }
        } else {
            echo "Kļūda sagatavojot jautājumu vaicājumu: " . $conn->error . "<br>";
        }
    }
    // Pāradresē lietotāju uz testu pārvaldīšanas lapu pēc testa izveidošanas
    header("Location: ../html/testu_parvaldisana.html");
    exit(); // Pārliecinieties, ka iziet pēc pāradresācijas
} else {
    echo "Kļūda: " . $stmt->error . "<br>";
}

// Aizver vaicājumus un savienojumu
$stmt->close();
$conn->close();
?>
